(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     22897,        671]*)
(*NotebookOutlinePosition[     23597,        695]*)
(*  CellTagsIndexPosition[     23553,        691]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Transformada de Fourier Discreta", "Title"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Soluciones de los ejercicios", "Section"]], "Section"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "a) Define un comando que proporcione simb\[OAcute]licamente los vectores \
\[Omega][n,N]  (",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] n \[LessEqual] N - 1\)]],
  ").\nb) Comprueba para ",
  Cell[BoxData[
      \(TraditionalForm\`N = 6\)]],
  " que los vectores antes definidos forman una base ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalC]\^6\)]],
  ". Usa el comando Simplify[ ] si es preciso.\nc) Define un comando \
DFT[lista] que proporcione la transformada de Fourier discreta de \"lista\". \
Usa para ello los vectores \[Omega][n,N] y el producto escalar.\nObservaci\
\[OAcute]n: Claro est\[AAcute] que este comando no es \[UAcute]til para hacer \
c\[AAcute]lculos largos, pero tiene la ventaja de que puede trabajar simb\
\[OAcute]licamente lo que nos permite entender bien lo que hace. \nd) Decimos \
que la se\[NTilde]al ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es par si es sim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  " (suponemos que ",
  StyleBox["N",
    FontSlant->"Italic"],
  " es par), es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = y\_\(N/2 + k\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". Decimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["y",
            FontWeight->"Bold"], "=", \((y\_0, y\_1,  ... , y\_\(N - 1\))\)}],
         TraditionalForm]]],
  " es impar si es antisim\[EAcute]trica respecto de ",
  Cell[BoxData[
      \(TraditionalForm\`N/2\)]],
  ", es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`y\_\(N/2 - k\) = \(-y\_\(N/2 + k\)\)\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`k = 0, 1,  ... , \ N/2 - 1\)]],
  ". \nDefine comandos \"par[se\[NTilde]al]\"  (\"impar[se\[NTilde]al]\") que \
transformen una se\[NTilde]al (finita) dada en otra se\[NTilde]al par (impar) \
de forma que se verifique la igualdad\n\t\t\tse\[NTilde]al = \
par[se\[NTilde]al] + impar[se\[NTilde]al]\nadem\[AAcute]s, si la \
se\[NTilde]al es par debe ser  se\[NTilde]al = par[se\[NTilde]al].\n\
Sugerencia: Usa el comando Reverse[].\ne) Define un comando \"rlist[n]\" que \
genere aleatoriamente una lista de n n\[UAcute]meros. Define a= rlist[32]. \
Calcula DFT[a] y comprueba por simple inspecci\[OAcute]n que todos sus \
elementos son reales y es par. Calcula DFT[impar[a]] y comprueba por simple \
inspecci\[OAcute]n que todos sus elementos, excepto el primero y el que ocupa \
el lugar 17, son imaginarios puros y es impar. Comprueba, usando ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", que DFT[a] = DFT[par[a]] + DFT[impar[a]].\nSugerencia: Debes usar el \
comando Chop[ ] para eliminar las peque\[NTilde]as partes imaginarias o \
reales procedentes de errores de redondeo.\nf) Define un comando \
\"InverseDFT[lista]\" que calcule la inversa de la transformada de Fourier \
discreta. "
}], "ExerciseText"],

Cell[BoxData[
    RowBox[{\(\[Omega][n_, N_] := 
        Exp[2  \[ImaginaryI]\ \[Pi]\ n\ Range[0, N - 1]/N]\), " ", 
      RowBox[{"(*", " ", 
        RowBox[{"los", " ", "vectores", " ", 
          FormBox[
            SubscriptBox[
              StyleBox["\[Omega]",
                FontWeight->"Bold"], "n"],
            "TraditionalForm"], " ", "en", " ", \(\[DoubleStruckC]\^N\)}], 
        " ", "*)"}]}]], "Input"],

Cell[BoxData[
    \(DFT[muestra_] := 
      Table[1/Length[muestra] \((\ 
            muestra . \[Omega][\(-n\), Length[muestra]])\), {n, 0, 
          Length[muestra] - 1}]\)], "Input"],

Cell[TextData[{
  "Vamos a comprobar que los vectores ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["\[Omega]",
            FontWeight->"Bold"], "n"], TraditionalForm]]],
  " forman una base ortogonal."
}], "Text"],

Cell[BoxData[
    \(\(\(Table[\[Omega][n, 6], {n, 0, 
          5}]\)\(//\)\(\(MatrixForm\)\(\ \ \)\)\( (*\ 
        hacemos\ N = 6\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(Table[\[Omega][n, 6], {n, 0, 5}] . 
          Conjugate[Table[\[Omega][n, 6], {n, 0, 5}]]\  // 
        MatrixForm\)\(\ \)\(//\)\(Simplify\)\( (*\ 
        comprobamos\ que\ son\ ortogonales\ y\ su\ norma\ igual\ a\ \@6\ *) \
\)\)\)], "Input"],

Cell[BoxData[{
    \(par[list_] := 
      Module[{dlist = 
            Drop[list, 
              1]}, \[IndentingNewLine]Prepend[\((dlist + Reverse[dlist])\)/2, 
          list[\([1]\)]]\[IndentingNewLine]]\), "\[IndentingNewLine]", 
    \(impar[list_] := 
      Module[{dlist = 
            Drop[list, 
              1]}, \[IndentingNewLine]Prepend[\((dlist - Reverse[dlist])\)/2, 
          0]\[IndentingNewLine]]\), "\[IndentingNewLine]", 
    \(rlist[n_] := Table[Random[], {n}]\)}], "Input"],

Cell[BoxData[
    \(a = rlist[32]\)], "Input"],

Cell[BoxData[
    \(DFT[a]\)], "Input"],

Cell[BoxData[
    \(DFT[par[a]] // Chop\)], "Input"],

Cell[BoxData[
    \(DFT[impar[a]] // Chop\)], "Input"],

Cell[BoxData[
    \(DFT[a] \[Equal] DFT[par[a]] + DFT[impar[a]]\)], "Input"],

Cell["\<\
Las siguientes operaciones te indican c\[OAcute]mo calcular la transformaci\
\[OAcute]n inversa.\
\>", "Text"],

Cell[BoxData[
    \(Simplify[DFT[DFT[{a, b, c, d, e, f}]]]\)], "Input"],

Cell[BoxData[
    \(Reverse[%]\)], "Input"],

Cell[BoxData[
    \(RotateRight[%]\)], "Input"],

Cell[BoxData[
    \(\(\(6\) \( RotateRight[
        Reverse[Simplify[DFT[DFT[{a, b, c, d, e, f}]]]]]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(InverseDFT[
        muestra_] := \(\(Length[muestra]\)\(*\)\(RotateRight[
          Reverse[Simplify[DFT[muestra]]]]\)\( (*\ 
          esta\ es\ la\ transformaci\[OAcute]n\ inversa\ *) \)\)\)], "Input"],

Cell[BoxData[{
    \(InverseDFT[{1, 2, 3, 4, 5, 6}]\), "\n", 
    \(DFT[%] // Simplify\)}], "Input"],

Cell[BoxData[
    \(inversaDFT[transformada_] := 
      Table[\ transformada . \[Omega][n, Length[transformada]], {n, 0, 
          Length[transformada] - 1}]\)], "Input"],

Cell[BoxData[{
    \(DFT[{1, 2, 3, 4, 5, 6}]\), "\[IndentingNewLine]", 
    \(inversaDFT[%] // Simplify\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Considera la extensi\[OAcute]n 2\[Pi]-peri\[OAcute]dica de la funci\
\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f[t] = t\ Sin[t]\)]],
  "  (",
  Cell[BoxData[
      \(TraditionalForm\`\(-\[Pi]\) \[LessEqual] t \[LessEqual] \[Pi]\)]],
  "). Pide a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que construya una tabla de tres columnas con encabezados \"n\", \"c[n]\", \
\"Y[n]\"; donde n toma valores de 0 a 12; c[n] son los coeficientes de \
Fourier de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "; Y[n] son los valores de la transformada de Fourier discreta de una \
muestra de la extensi\[OAcute]n 2\[Pi]-peri\[OAcute]dica de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en ",
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  " puntos igualmente espaciados del intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, 2  \[Pi]]\)\)]],
  ". Haz dos tablas correspondientes a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 30\)]],
  " y a ",
  Cell[BoxData[
      \(TraditionalForm\`N = 100\)]],
  ". \nSugerencia: Puedes definir un comando que dependa de un \
par\[AAcute]metro ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " y que d\[EAcute] como salida la tabla que se pide. El comando TableForm[] \
puede ser \[UAcute]til. Procura hacer los c\[AAcute]lculos de forma num\
\[EAcute]rica."
}], "Text"],

Cell[BoxData[
    \(fp[t_] := \(\(Abs[t - 2  N[\[Pi]] Round[t/\((2  N[\[Pi]])\)]]\) \(Sin[
          Abs[t - 2  N[\[Pi]] Round[t/\((2  N[\[Pi]])\)]]]\)\( (*\ 
          extensi\[OAcute]n\ 2  \[Pi] - peri\[OAcute]dica\ de\ f[t] = 
            t\ Sin[t]\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[fp[t], {t, \(-4\) Pi, 4  Pi}];\)\)], "Input"],

Cell[BoxData[
    \(\(\(Clear[f, muestra, puntos]\[IndentingNewLine]
    \(f[t_] := 
        t*Sin[t] /; \(-N[\[Pi]]\) \[LessEqual] t \[LessEqual] N[\[Pi]];\)\n
    \(f[t_] := f[t - 2  N[\[Pi]]] /; t > N[\[Pi]];\)\[IndentingNewLine]
    muestra[k_] := f /@ \((\(N[2  \[Pi]]\/k\) Range[0, k - 1])\) // Chop\n
    c[k_] := 
      Chop[\(1\/\(2  \[Pi]\)\) 
          NIntegrate[\[ExponentialE]\^\(\(-k\)\ \[ImaginaryI]\ t\)\ f[
                t], {t, \(-\[Pi]\), \[Pi]}, AccuracyGoal \[Rule] 4]]\  (*\ 
      coeficientes\ de\ Fourier\ de\ f\ *) \n
    comparacoeff[k_] := 
      TableForm[
        Table[{j, c[j], Chop[\(DFT[muestra[k]]\)[\([j + 1]\)]]}, {j, 0, 
            Min[k/2, 15] - 1}], 
        TableHeadings -> {\ {}, {"\<n\>", "\<c[n]\>", \
\*"\"\<\!\(Y\_n\)\>\""}}, TableAlignments -> Center]\)\(\ \)\( (*\ 
      no\ comparamos\ m\[AAcute]s\ que\ los\ primeros\ 10\ coeficientes\ para\
\ evitar\ c\[AAcute]lculos\ demasiado\ largos\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(comparacoeff[30]\)], "Input"],

Cell["\<\
Naturalmente, la aproximaci\[OAcute]n es mejor cuantos m\[AAcute]s puntos \
tenga la muestra.\
\>", "Text"],

Cell[BoxData[
    \(comparacoeff[100]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "DFT en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando \"Fourier[lista]\" para calcular la DFT que usa el \
algoritmo de la Transformada R\[AAcute]pida de Fourier. Pero ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " define la DFT en la forma siguiente:\n\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`Y\_n = \(1\/\@N\) \(\[Sum]\+\(k = 1\)\%N\(\( 
                  y\_k\) \(\[ExponentialE]\^\(2\ \[ImaginaryI]\ \[Pi]\ \((n - 
                        1)\) \((\ k - 1)\)/
                      N\)\)\(\ \ \ \ \ \ \ \ \ \ \ \ \)\((n = 1, 2,  ... , 
                N)\)\(\ \)\)\)\)]],
  "\nes decir, divide por ",
  Cell[BoxData[
      \(TraditionalForm\`\@N\)]],
  "en vez de por ",
  StyleBox["N",
    FontSlant->"Italic"],
  " y conjuga las exponenciales. Para que el comando \"Fourier[lista]\" \
proporcione la DFT que hemos definido nosotros hay que ajustar unos par\
\[AAcute]metros (consulta la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "). Ejecuta las siguientes celdas para entender la relaci\[OAcute]n entre \
nuestro comando DFT[ ] y Fourier[ ]."
}], "Text"],

Cell[BoxData[
    \(DFT[{1.  + 1.  I, 2. , 3. , 4. , 5. }]\)], "Input"],

Cell[BoxData[
    \(1/Sqrt[5. ] 
      RotateLeft[
        Reverse[Fourier[{1.  + I, 2. , 3. , 4. , 5. }]], \(-1\)]\)], "Input"],

Cell[BoxData[
    \(\(\(Fourier[{1.  + 1.  I, 2. , 3. , 4. , 5. }, 
      FourierParameters \[Rule] {\(-1\), \(-1\)}]\)\( (*\ 
      no\ funciona\ en\ la\ versi\[OAcute]n\ 3.0\ *) \)\)\)], "Input"],

Cell["\<\
No te debe caber duda de cu\[AAcute]l es el que hay que usar para hacer c\
\[AAcute]lculos.\
\>", "Text"],

Cell[BoxData[{
    \(Clear[lista]\), "\[IndentingNewLine]", 
    \(\(lista = Table[Random[], {1024}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[
        Fourier[lista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\  (*\ 
      visto\ y\ no\ visto\ *) \), "\[IndentingNewLine]", 
    \(\(Timing[DFT[lista]]\)[\([1]\)] (*\ espera\ un\ poco, \ 
      ten\ paciencia; \ 
      hay\ que\ hacer\ m\[AAcute]s\ de\ un\ mill\[OAcute]n\ de\ operaciones\ *) \
\)}], "Input"],

Cell[TextData[{
  "Ahora puedes apreciar el ahorro que proporciona el algoritmo de la \
transformada r\[AAcute]pida de Fourier. Pongamos a prueba el algoritmo con \
una muestra grande de ",
  Cell[BoxData[
      \(TraditionalForm\`2\^15 = 32678\)]],
  " datos. Solamente pretender almacenar la matriz de los \[Omega][n,N] para \
N=32678 ya ser\[IAcute]a un problema. "
}], "Text"],

Cell[BoxData[{
    \(Clear[lista]\), "\[IndentingNewLine]", 
    \(\(lista = Table[Random[], {32678}];\)\), "\[IndentingNewLine]", 
    \(\(Timing[
        Fourier[lista, 
          FourierParameters \[Rule] {\(-1\), \(-1\)}]]\)[\([1]\)]\), "\
\[IndentingNewLine]", 
    \(Clear[lista]\)}], "Input"],

Cell["No est\[AAcute] mal \[DownQuestion]verdad?.", "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando \"CirculantMatrix[lista]\" que construye una matriz \
circulante a partir de una lista dada. Usa para ello los comandos Transpose[ \
], RotateRight[ ], NestList[ ].\nb) Define un comando CiclicConvolve[x,y] que \
calcule la convoluci\[OAcute]n c\[IAcute]clica ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["x",
            FontWeight->"Bold"], 
          StyleBox[
            FormBox["\[CircleDot]",
              "TraditionalForm"],
            FontWeight->"Bold"], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["y",
            FontWeight->"Bold"]}], TraditionalForm]]],
  ".\nc) Comprueba simb\[OAcute]licamente para listas de 4 elementos que",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{" ", 
            RowBox[{
              FormBox[
                StyleBox[
                  RowBox[{"x", 
                    FormBox["\[CircleDot]",
                      "TraditionalForm"], " ", "y"}],
                  FontWeight->"Bold"],
                "TraditionalForm"], "=", \(y\[CircleDot]x\)}]}],
          FontWeight->"Bold"], TraditionalForm]]],
  ".\nd) Comprueba simb\[OAcute]licamente para listas de N=4 elementos que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(DFT[x\[CircleDot]\ y] = N\ DFT[x]\ DFT[y]\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "ExerciseText"],

Cell[BoxData[
    \(Transpose[NestList[RotateRight, {a, b, c, d}, 3]] // 
      MatrixForm\)], "Input"],

Cell[BoxData[
    \(CirculantMatrix[lista_] := 
      Transpose[NestList[RotateRight, lista, Length[lista] - 1]]\)], "Input"],

Cell[BoxData[
    \(CirculantMatrix[{a, b, c, d, e}] // MatrixForm\)], "Input"],

Cell[BoxData[
    \(CiclicConvolve[x_, y_] := CirculantMatrix[y] . x\)], "Input"],

Cell["Podemos comprobar la propiedad conmutativa de la convoluci\[OAcute]n", \
"Text"],

Cell[BoxData[{
    \(CiclicConvolve[{a, b, c, d}, {x, y, z, u}]\), "\[IndentingNewLine]", 
    \(CiclicConvolve[{x, y, z, u}, {a, b, c, d}]\)}], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando \"ListConvolve[n\[UAcute]cleo,lista]\" (consulta la \
ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ") que con un ajuste de par\[AAcute]metros permite calcular convoluciones c\
\[IAcute]clicas (aunque el comando de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " es mucho m\[AAcute]s general)."
}], "Text"],

Cell[BoxData[
    \(ListConvolve[{a, b, c}, {x, y, z}, 1]\)], "Input"],

Cell[TextData[{
  "Podemos tambi\[EAcute]n comprobar la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"\[ScriptCapitalF]", " ", 
            RowBox[{"(", 
              RowBox[{
                StyleBox["x",
                  FontWeight->"Bold"], 
                FormBox[\(\(\ \)\(\[CircleDot]\)\),
                  "TraditionalForm"], " ", 
                StyleBox["y",
                  FontWeight->"Bold"]}], 
              StyleBox[")",
                FontWeight->"Bold"]}]}], 
          StyleBox["=",
            FontWeight->"Bold"], 
          RowBox[{
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["N",
                    FontWeight->"Bold"], "\[ScriptCapitalF]"}]], "(", 
              StyleBox["x",
                FontWeight->"Bold"], ")"}], 
            RowBox[{"\[ScriptCapitalF]", "(", 
              StyleBox["y",
                FontWeight->"Bold"], ")"}]}]}], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[{
    \(DFT[CiclicConvolve[{a, b, c}, {x, y, z}]] // 
      Expand\), "\[IndentingNewLine]", 
    \(3  DFT[{a, b, c}] DFT[{x, y, z}] // Expand\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Filtros", "Section"],

Cell[BoxData[{
    \(Off[General::spell1]\), "\[IndentingNewLine]", 
    \(Off[General::spell]\)}], "Input"],

Cell[BoxData[
    \(\(sizes = 
        Sort[Flatten[
            Table[2^i\ 3^j\ \ 5^k, {i, 1, 15}, {j, 0, 
                Floor[Log[3, 32768. /\((2^i)\)]]}, {k, 0, 
                Floor[Log[5, 32768. /\((2^i\ 3^j)\)]]}]]];\)\)], "Input"],

Cell[BoxData[
    \(eligesize[x_] := 
      Module[{p = Max[sizes], q}, \[IndentingNewLine]If[x \[LessEqual] \ p, 
          First[Select[sizes, \((# \[GreaterEqual] x)\) &]], 
          q = Ceiling[Log[2, N[x]/p]]; 
          2^q\ First[
              Select[sizes, \((# \[GreaterEqual] \((2^\(-q\))\)\ x)\) \
&]]]]\)], "Input"],

Cell[BoxData[
    \(filtropasobanda[sound_SampledSoundList, fmin_, fmax_] := 
      Block[{samps, srate, origsize, \ newsize, kern, nfmin, nfmax, 
          n}, \[IndentingNewLine]samps = 
          sound[\([1]\)]; \[IndentingNewLine]srate = 
          sound[\([2]\)]; \[IndentingNewLine]origsize = 
          Length[samps]; \[IndentingNewLine]newsize = 
          2*eligesize[origsize]; \[IndentingNewLine]samps = 
          Join[samps, 
            Table[0.0, {newsize - 
                  origsize}]]; \[IndentingNewLine]nfmin = \((fmin*newsize)\)/
            srate; \[IndentingNewLine]nfmax = \((fmax*newsize)\)/
            srate; \[IndentingNewLine]kern = 
          Table[If[n \[GreaterEqual] \ nfmin && \ n \[LessEqual] \ nfmax, 
              1.0, 0.0], {n, \((newsize/2)\) + 1}]; \[IndentingNewLine]kern = 
          Join[kern, 
            Take[Reverse[
                Drop[Drop[kern, 1], \(-1\)]]]]; \[IndentingNewLine]samps = 
          Take[Chop[
              Re[\[IndentingNewLine]InverseFourier[kern*Fourier[samps]]]], 
            origsize]; \[IndentingNewLine]samps = 
          samps/Max[Abs[samps]]; \[IndentingNewLine]Return[
          SampledSoundList[samps, srate]]\[IndentingNewLine]]\)], "Input"],

Cell[BoxData[{
    \(\(sines = 
        SampledSoundList[
          Table[N[0.3\ \((Sin[2\ Pi\ 400. \ x] + Sin[2\ Pi\ 1600. \ x] + 
                    Sin[2\ Pi\ 3600. \ x])\)], {x, 0, 1 - 1/22500.0, 
              1/22500.0}], 22500];\)\), "\n", 
    \(\(Show[Sound[sines]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(lsine = filtropasobanda[sines, 0, 600];\)\), "\n", 
    \(\(Show[Sound[lsine]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(msine = filtropasobanda[sines, 1500, 1700];\)\), "\n", 
    \(\(Show[Sound[msine]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(hsine = filtropasobanda[sines, 3500, 3700];\)\), "\n", 
    \(\(Show[Sound[hsine]];\)\)}], "Input"],

Cell[BoxData[
    \(\(CombinedSoundShow[{Sound[sines], Sound[lsine], Sound[msine], 
          Sound[hsine]}];\)\)], "Input"],

Cell[BoxData[
    \(Position[Abs[trans], _?\((# \[NotEqual] 0 &)\)]\)], "Input"],

Cell[BoxData[
    \(convolucion[x_, y_] := 
      Module[{lx = Length[x], ly = Length[y]}, \[IndentingNewLine]Drop[
          Table[Sum[
              x[\([k]\)]*\ y[\([n - k]\)], {k, Max[1, n - ly], 
                Min[n - 1, lx]}], {n, 1, lx + ly}], 1]]\)], "Input"],

Cell[BoxData[
    \(SetDirectory["\<D:\Trabajo\Docencia \
Informatica\Ingenieria_Informatica\Curso2004_2005\Calculo_Avanzado\Practicas\ \
\>"]\)], "Input"],

Cell[BoxData[{
    \(\(nessun = Import["\<pavrti.wav\>"];\)\), "\n", 
    \(Short[InputForm[nessun]]\)}], "Input"],

Cell[BoxData[{
    \(\(nesunbajo = 
        filtropasobanda[nessun[\([\)\(1\)\(]\)], 0, 1000];\)\), "\n", 
    \(Show[Sound[nesunbajo]]\)}], "Input"],

Cell[BoxData[{
    \(\(nesunmedio = 
        filtropasobanda[nessun[\([\)\(1\)\(]\)], 1000, 2000];\)\), "\n", 
    \(Show[Sound[nesunmedio]]\)}], "Input"],

Cell[BoxData[{
    \(\(nesunalto = 
        filtropasobanda[nessun[\([\)\(1\)\(]\)], 2000, 8000];\)\), "\n", 
    \(Show[Sound[nesunalto]]\)}], "Input"],

Cell[BoxData[
    \(\(CombinedSoundShow[{nessun, Sound[nesunbajo], Sound[nesunmedio], 
          Sound[nesunalto]}];\)\)], "Input"],

Cell[BoxData[{
    \(\(papa = Import["\<papa.wav\>"];\)\), "\n", 
    \(Show[papa]\)}], "Input"],

Cell[BoxData[{
    \(\(filtropasobanda[papa[\([\)\(1\)\(]\)], 2000, 4000];\)\), "\n", 
    \(Show[Sound[%]]\)}], "Input"],

Cell[BoxData[{
    \(\(niniomedio = 
        filtropasobanda[papa[\([\)\(1\)\(]\)], 1000, 2000];\)\), "\n", 
    \(\(Show[Sound[niniomedio]];\)\)}], "Input"],

Cell[BoxData[{
    \(\(niniobajo = 
        filtropasobanda[papa[\([\)\(1\)\(]\)], 0, 1000];\)\), "\n", 
    \(\(Show[Sound[niniobajo]];\)\)}], "Input"],

Cell[BoxData[{
    \(logistic[n_Integer] := 
      Module[{f, t, x}, \[IndentingNewLine]f = 
          Compile[{x, t}, Evaluate[\((3 + t\/n)\)\ x\ \((1 - x)\)]]; 
        FoldList[f, 0.223, Range[n]]]\), "\n", 
    \(\(ListPlay[logistic[8000], SampleRate \[Rule] 2000];\)\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 788}},
WindowSize->{1144, 747},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 49, 0, 99, "Title"],

Cell[CellGroupData[{
Cell[1828, 55, 78, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[1931, 59, 31, 0, 68, "Exercise"],
Cell[1965, 61, 3125, 70, 623, "ExerciseText"],
Cell[5093, 133, 420, 10, 72, "Input"],
Cell[5516, 145, 186, 4, 98, "Input"],
Cell[5705, 151, 243, 8, 41, "Text"],
Cell[5951, 161, 153, 3, 72, "Input"],
Cell[6107, 166, 267, 5, 104, "Input"],
Cell[6377, 173, 496, 11, 228, "Input"],
Cell[6876, 186, 46, 1, 72, "Input"],
Cell[6925, 189, 39, 1, 72, "Input"],
Cell[6967, 192, 52, 1, 72, "Input"],
Cell[7022, 195, 54, 1, 72, "Input"],
Cell[7079, 198, 76, 1, 72, "Input"],
Cell[7158, 201, 120, 3, 41, "Text"],
Cell[7281, 206, 71, 1, 72, "Input"],
Cell[7355, 209, 43, 1, 72, "Input"],
Cell[7401, 212, 47, 1, 72, "Input"],
Cell[7451, 215, 123, 2, 72, "Input"],
Cell[7577, 219, 223, 4, 124, "Input"],
Cell[7803, 225, 100, 2, 98, "Input"],
Cell[7906, 229, 171, 3, 98, "Input"],
Cell[8080, 234, 117, 2, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8234, 241, 31, 0, 68, "Exercise"],
Cell[8268, 243, 1379, 39, 183, "Text"],
Cell[9650, 284, 273, 4, 98, "Input"],
Cell[9926, 290, 72, 1, 72, "Input"],
Cell[10001, 293, 965, 18, 391, "Input"],
Cell[10969, 313, 49, 1, 72, "Input"],
Cell[11021, 316, 117, 3, 41, "Text"],
Cell[11141, 321, 50, 1, 72, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11240, 328, 94, 4, 93, "Section"],
Cell[11337, 334, 1141, 27, 201, "Text"],
Cell[12481, 363, 71, 1, 72, "Input"],
Cell[12555, 366, 128, 3, 72, "Input"],
Cell[12686, 371, 197, 3, 98, "Input"],
Cell[12886, 376, 115, 3, 41, "Text"],
Cell[13004, 381, 486, 10, 176, "Input"],
Cell[13493, 393, 380, 8, 67, "Text"],
Cell[13876, 403, 299, 7, 150, "Input"],
Cell[14178, 412, 59, 0, 41, "Text"],

Cell[CellGroupData[{
Cell[14262, 416, 31, 0, 68, "Exercise"],
Cell[14296, 418, 1422, 38, 169, "ExerciseText"],
Cell[15721, 458, 103, 2, 72, "Input"],
Cell[15827, 462, 125, 2, 94, "Input"],
Cell[15955, 466, 79, 1, 72, "Input"],
Cell[16037, 469, 81, 1, 94, "Input"],
Cell[16121, 472, 86, 1, 41, "Text"],
Cell[16210, 475, 153, 2, 98, "Input"],
Cell[16366, 479, 431, 12, 67, "Text"],
Cell[16800, 493, 70, 1, 72, "Input"],
Cell[16873, 496, 1001, 30, 41, "Text"],
Cell[17877, 528, 169, 3, 98, "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18095, 537, 26, 0, 93, "Section"],
Cell[18124, 539, 108, 2, 120, "Input"],
Cell[18235, 543, 240, 5, 146, "Input"],
Cell[18478, 550, 329, 7, 146, "Input"],
Cell[18810, 559, 1224, 22, 484, "Input"],
Cell[20037, 583, 292, 6, 124, "Input"],
Cell[20332, 591, 118, 2, 98, "Input"],
Cell[20453, 595, 122, 2, 98, "Input"],
Cell[20578, 599, 122, 2, 98, "Input"],
Cell[20703, 603, 124, 2, 72, "Input"],
Cell[20830, 607, 80, 1, 72, "Input"],
Cell[20913, 610, 269, 5, 120, "Input"],
Cell[21185, 617, 155, 3, 146, "Input"],
Cell[21343, 622, 114, 2, 98, "Input"],
Cell[21460, 626, 149, 3, 98, "Input"],
Cell[21612, 631, 154, 3, 98, "Input"],
Cell[21769, 636, 152, 3, 98, "Input"],
Cell[21924, 641, 131, 2, 94, "Input"],
Cell[22058, 645, 96, 2, 98, "Input"],
Cell[22157, 649, 121, 2, 98, "Input"],
Cell[22281, 653, 157, 3, 98, "Input"],
Cell[22441, 658, 152, 3, 98, "Input"],
Cell[22596, 663, 285, 5, 154, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

